/*----------------------------------------------------------------------------
 * Name:    led.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 *----------------------------------------------------------------------------*/
#include	"led.h"
#include	"main.h"

typedef struct
{
	u16	TimerCount;
	u16 LED1_Timer;
	u16 LED2_Timer;
	u16 LED3_Timer;
	u16 LED4_Timer;
}LED_Timer;

typedef struct 
{
	u8	status:1;
	u8	mode;
	u8	Port;
	u16	frequency;
	LED_Timer worktime;	
}LED_Flag;

LED_Flag LEDStatus;

/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_InterfaceConfigure(void)
{	
   /* configure LED as GPIO  */
	_pbc &= 0xE7;			/* LED1/2 output mode */
	_pac7 = LOW;			/* LED3 output mode */
	
	LED1_OFF;
	LED2_OFF;
	LED3_OFF;
}

void LED_STATUS(u8 active,u8 mode,u8 LEDIO,u16 frequency,u16 time)
{
	LEDStatus.status = active;
	LEDStatus.mode = mode;
	LEDStatus.Port =  LEDIO;
				
	if(LEDStatus.mode & (Flashing_Mode | BrightToDark_Mode | AlwaysDark_Mode))	
	{
		LEDStatus.worktime.TimerCount = time;
		if(LEDStatus.mode == Flashing_Mode)	{
		LEDStatus.frequency = frequency;	
		if(LEDIO & LED1)
		LEDStatus.worktime.LED1_Timer = time;
		if(LEDIO & LED2)
		LEDStatus.worktime.LED2_Timer = time;
		if(LEDIO & LED3)
		LEDStatus.worktime.LED3_Timer = time; }
	}
}

void LED_Process()
{
	if(LEDStatus.status == ENABLE) 
	{
		/* LED flash code*/
		if(LEDStatus.mode == Flashing_Mode)
		{
			if(--LEDStatus.worktime.TimerCount == 0)
			{
				switch(LEDStatus.Port)
				{
					case LED1:
						LEDStatus.worktime.TimerCount = LEDStatus.worktime.LED1_Timer;
						LED1_TOGGLE;						
					break;
					case LED2:
						LEDStatus.worktime.TimerCount = LEDStatus.worktime.LED2_Timer;
						LED2_TOGGLE;						
					break;
					case LED3:
						LEDStatus.worktime.TimerCount = LEDStatus.worktime.LED3_Timer;
						LED3_TOGGLE;				
					break;
				}				
				
				if(--LEDStatus.frequency == 0)  {
				LEDStatus.status = DISABLE;		
				BC5161_FlearnFail = TRUE;	} 
			}
		}
		
		if(LEDStatus.mode == AlwaysBright_Mode)
		{
			if(LEDStatus.Port & LED1)
				LED1_ON;
			if(LEDStatus.Port & LED2)
				LED2_ON;
			if(LEDStatus.Port & LED3)
				LED3_ON;
			LEDStatus.status = DISABLE;
		}	
		
		if(LEDStatus.mode == AlwaysDark_Mode)
		{
			if(--LEDStatus.worktime.TimerCount == 0)
			{
				if(LEDStatus.Port & LED1)
					LED1_OFF;
				if(LEDStatus.Port & LED2)
					LED2_OFF;
				if(LEDStatus.Port & LED3)
					LED3_OFF;
					
				LEDStatus.status = DISABLE;
			}									
		}
		
		if(LEDStatus.mode == BrightToDark_Mode)
		{
			if(LEDStatus.Port & LED1)
				LED1_ON;
			if(LEDStatus.Port & LED2)
				LED2_ON;
			if(LEDStatus.Port & LED3)
				LED3_ON;
				
			if(--LEDStatus.worktime.TimerCount == 0)
			{
				if(LEDStatus.Port & LED1)
					LED1_OFF;
				if(LEDStatus.Port & LED2)
					LED2_OFF;
				if(LEDStatus.Port & LED3)
					LED3_OFF;	
					
				LEDStatus.status = DISABLE;
			}
		}
		
		if(LEDStatus.status == DISABLE)	
		{
			LEDStatus.mode = Idle_Mode;
			LEDStatus.Port = 0;	
		}
	}
}

